#include "scripts.h"
#include "engine.h"
#include "jfw3.h"

void JFW_Apply_Damage_On_Enter_Timer::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Commands->Get_ID(enter));
}
void JFW_Apply_Damage_On_Enter_Timer::Timer_Expired(GameObject * obj,int number)
{
	float f;
	const char *w;
	float distance;
	Vector3 pos1;
	Vector3 pos2;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Distance"))
	{
		w = Get_Parameter("Warhead");
		f = Get_Float_Parameter("Damage");
		Commands->Apply_Damage(Commands->Find_Object(number),f,w,0);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),number);
	}
}
void JFW_Apply_Damage_On_Enter_Timer::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ID);
}
void JFW_Zone_Send_Custom_Not_Preset::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	const char *preset;
	const char *c;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("EnterMessage");
	param = Get_Int_Parameter("EnterParam");
	object = Commands->Find_Object(ID);
	c = Get_Parameter("Preset_Name");
	preset = Commands->Get_Preset_Name(enter);
	if (strcmp(preset,c) != 0)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(enter);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Not_Preset::Exited(GameObject * obj, GameObject * exit)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	const char *preset;
	const char *c;
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("ExitMessage");
	param = Get_Int_Parameter("ExitParam");
	object = Commands->Find_Object(ID);
	c = Get_Parameter("Preset_Name");
	preset = Commands->Get_Preset_Name(exit);
	if (strcmp(preset,c) != 0)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(exit);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Keycard::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	int pltype;
	int key;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("EnterMessage");
	param = Get_Int_Parameter("EnterParam");
	object = Commands->Find_Object(ID);
	key = Get_Int_Parameter("Keycard_Number");
	if (Commands->Has_Key(enter,key) == true)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(enter);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Zone_Send_Custom_Keycard::Exited(GameObject * obj, GameObject * exit)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	int pltype;
	int key;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("ExitMessage");
	param = Get_Int_Parameter("ExitParam");
	object = Commands->Find_Object(ID);
	key = Get_Int_Parameter("Keycard_Number");
	if (Commands->Has_Key(exit,key) == true)
	{
		if (message != 0)
		{
			if (param == 0)
			{
				param = Commands->Get_ID(exit);
			}
			Commands->Send_Custom_Event(obj,object,message,param,0);
		}
	}
}
void JFW_Give_Points_On_Death::Killed(GameObject * obj,GameObject * shooter)
{
	int pltype;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(shooter,pltype) != 0)
	{
		return;
	}
	Commands->Give_Points(shooter,Get_Float_Parameter("Points"),Get_Int_Parameter("Whole_Team"));
}
void JFW_Turret_Spawn_2::Created(GameObject * obj)
{
	Vector3 sp;
	GameObject *object;
	sp.X = 0;
	sp.Y = 0;
	sp.Z = 0;
	object = Commands->Create_Object(Get_Parameter("Turret_Preset"),sp);
	Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("Bone_Name"));
	turID = Commands->Get_ID(object);
}
void JFW_Turret_Spawn_2::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&turID);
}
void JFW_Turret_Spawn_2::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 tmb;
	tmb = Commands->Get_Bone_Position(obj,Get_Parameter("Explosion_Bone"));
	Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),tmb,0);
}
void JFW_Teleport_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg = Get_Int_Parameter("Message");
	if (message == msg) 
	{
		Vector3 spawn_position;
		spawn_position = Get_Vector3_Parameter("Location");
		int x = Get_Int_Parameter("Object_ID");
		if (x != 0)
		{
			GameObject * gotoObject = Commands->Find_Object(x);
			Vector3 gotoLocation = Commands->Get_Position(gotoObject);
			Commands->Set_Position(Commands->Find_Object(param),gotoLocation);
		}
		else
			Commands->Set_Position(Commands->Find_Object(param),spawn_position);
	}
}
void JFW_Teleport_Custom_Random::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg = Get_Int_Parameter("Message");
	Vector3 spawn_position;
	int x = 0;
	if (message == msg) 
	{
		int rand = Commands->Get_Random_Int(1,5);
		if (rand == 1)
		{
			spawn_position = Get_Vector3_Parameter("Location1");
			x = Get_Int_Parameter("Object_ID1");
		}
		if (rand == 2)
		{
			spawn_position = Get_Vector3_Parameter("Location2");
			x = Get_Int_Parameter("Object_ID2");
		}
		if (rand == 3)
		{
			spawn_position = Get_Vector3_Parameter("Location3");
			x = Get_Int_Parameter("Object_ID3");
		}
		if (rand == 4)
		{
			spawn_position = Get_Vector3_Parameter("Location4");
			x = Get_Int_Parameter("Object_ID4");
		}
		if (rand == 5)
		{
			spawn_position = Get_Vector3_Parameter("Location5");
			x = Get_Int_Parameter("Object_ID5");
		}
		if (x != 0)
		{
			GameObject * gotoObject = Commands->Find_Object(x);
			Vector3 gotoLocation = Commands->Get_Position(gotoObject);
			Commands->Set_Position(Commands->Find_Object(param),gotoLocation);
		}
		else
			Commands->Set_Position(Commands->Find_Object(param),spawn_position);
	}
}
void JFW_Teleport_Custom_Timer::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg = Get_Int_Parameter("Message");
	if ((message == msg) && (enabled == true))
	{
		Vector3 spawn_position;
		spawn_position = Get_Vector3_Parameter("Location");
		int x = Get_Int_Parameter("Object_ID");
		if (x != 0)
		{
			GameObject * gotoObject = Commands->Find_Object(x);
			Vector3 gotoLocation = Commands->Get_Position(gotoObject);
			Commands->Set_Position(Commands->Find_Object(param),gotoLocation);
		}
		else
		{
			Commands->Set_Position(Commands->Find_Object(param),spawn_position);
		}
		enabled = false;
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
	}
}
void JFW_Teleport_Custom_Timer::Timer_Expired(GameObject * obj,int number)
{
	enabled = true;
}
void JFW_Teleport_Custom_Timer::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Teleport_Custom_Timer::Created(GameObject * obj)
{
	enabled = true;
}
void JFW_Armour_Regen::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Armour_Regen::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	float timertime;
	float armour;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (number == timernumber)
	{
		armour = Commands->Get_Shield_Strength(obj);
		armour += Get_Float_Parameter("Points");
		if (armour > Commands->Get_Max_Shield_Strength(obj))
		{
			armour = Commands->Get_Max_Shield_Strength(obj);
		}
		Commands->Set_Shield_Strength(obj,armour);
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
}
void JFW_Health_Regen::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Health_Regen::Timer_Expired(GameObject * obj,int number)
{
	int timernumber;
	float timertime;
	float armour;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (number == timernumber)
	{
		armour = Commands->Get_Health(obj);
		armour += Get_Float_Parameter("Points");
		if (armour > Commands->Get_Max_Health(obj))
		{
			armour = Commands->Get_Max_Health(obj);
		}
		Commands->Set_Health(obj,armour);
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
}
void JFW_Blow_Up_Location_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *c;
	int msg;
	Vector3 v;
	msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		c = Get_Parameter("Explosion");
		v = Get_Vector3_Parameter("Location");
		Commands->Create_Explosion(c,v,0);
	}
}
void JFW_Customs_Play_Cinematic::Created(GameObject * obj)
{
	if (Get_Int_Parameter("Message1") == 0)
	{
		custom1 = true;
	}
	else
	{
		custom1 = false;
	}
	if (Get_Int_Parameter("Message2") == 0)
	{
		custom2 = true;
	}
	else
	{
		custom2 = false;
	}
	if (Get_Int_Parameter("Message3") == 0)
	{
		custom3 = true;
	}
	else
	{
		custom3 = false;
	}
	if (Get_Int_Parameter("Message4") == 0)
	{
		custom4 = true;
	}
	else
	{
		custom4 = false;
	}
	if (Get_Int_Parameter("Message5") == 0)
	{
		custom5 = true;
	}
	else
	{
		custom5 = false;
	}
	if (Get_Int_Parameter("Message6") == 0)
	{
		custom6 = true;
	}
	else
	{
		custom6 = false;
	}
	if (Get_Int_Parameter("Message7") == 0)
	{
		custom7 = true;
	}
	else
	{
		custom7 = false;
	}
	if (Get_Int_Parameter("Message8") == 0)
	{
		custom8 = true;
	}
	else
	{
		custom8 = false;
	}
	trigger = false;
}
void JFW_Customs_Play_Cinematic::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	msg = Get_Int_Parameter("Message1");
	if (message == msg)
	{
		custom1 = true;
	}
	msg = Get_Int_Parameter("Message2");
	if (message == msg)
	{
		custom2 = true;
	}
	msg = Get_Int_Parameter("Message3");
	if (message == msg)
	{
		custom3 = true;
	}
	msg = Get_Int_Parameter("Message4");
	if (message == msg)
	{
		custom4 = true;
	}
	msg = Get_Int_Parameter("Message5");
	if (message == msg)
	{
		custom5 = true;
	}
	msg = Get_Int_Parameter("Message6");
	if (message == msg)
	{
		custom6 = true;
	}
	msg = Get_Int_Parameter("Message7");
	if (message == msg)
	{
		custom7 = true;
	}
	msg = Get_Int_Parameter("Message8");
	if (message == msg)
	{
		custom8 = true;
	}
	if (trigger == false)
	{
		if ((custom1 == true) && (custom2 == true) && (custom3 == true) && (custom4 == true) && (custom5 == true) && (custom6 == true) && (custom7 == true) && (custom8 == true))
		{
			trigger = true;
			scriptname = Get_Parameter("Script_Name");
			position = Get_Vector3_Parameter("Location");
			facing = Get_Float_Parameter("Facing");
			object = Commands->Create_Object("Invisible_Object",position);
			Commands->Set_Facing(object,facing);
			Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		}
	}
}
void JFW_Customs_Play_Cinematic::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&custom1);
	Auto_Save_Variable(2,1,&custom2);
	Auto_Save_Variable(3,1,&custom3);
	Auto_Save_Variable(4,1,&custom4);
	Auto_Save_Variable(5,1,&custom5);
	Auto_Save_Variable(6,1,&custom6);
	Auto_Save_Variable(7,1,&custom7);
	Auto_Save_Variable(8,1,&custom8);
	Auto_Save_Variable(9,1,&trigger);
}
void JFW_Domination_Zone::Created(GameObject * obj)
{
	enabled = true;
	GameObject *object;
	float facing;
	object = Commands->Create_Object("Generic_Cinematic",Commands->Get_Position(obj));
	Commands->Enable_Hibernation(object,false);
	Commands->Add_To_Dirty_Cull_List(object);
	Commands->Set_Model(object,Get_Parameter("Neutral_Model"));
	facing = Commands->Get_Facing(obj);
	Commands->Set_Facing(object,facing);
	currentmodelid = Commands->Get_ID(object);
	owner = 2;
}
void JFW_Domination_Zone::Entered(GameObject * obj,GameObject * enter)
{
	float timertime;
	int timernumber;
	GameObject *object;
	float facing;
	int message;
	if (enabled == false)
	{
		return;
	}
	if (Commands->Get_Player_Type(enter) == owner)
	{
		return;
	}
	if (owner == 2)
	{
		message = Get_Int_Parameter("NeutralMessage");
	}
	else
	{
		message = Get_Int_Parameter("OwnedMessage");
	}
	Commands->Destroy_Object(Commands->Find_Object(currentmodelid));
	object = Commands->Create_Object("Generic_Cinematic",Commands->Get_Position(obj));
	Commands->Enable_Hibernation(object,false);
	Commands->Add_To_Dirty_Cull_List(object);
	if (Commands->Get_Player_Type(enter) == 0)
	{
		Commands->Set_Model(object,Get_Parameter("Nod_Model"));
		owner = 0;
	}
	if (Commands->Get_Player_Type(enter) == 1)
	{
		Commands->Set_Model(object,Get_Parameter("GDI_Model"));
		owner = 1;
	}
	facing = Commands->Get_Facing(obj);
	Commands->Set_Facing(object,facing);
	currentmodelid = Commands->Get_ID(object);
	object = Commands->Find_Object(Get_Int_Parameter("Controler_ID"));
	Commands->Send_Custom_Event(obj,object,message,owner,0);
	enabled = false;
	timertime = Get_Float_Parameter("Capture_Delay_Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (timertime != 0)
	{
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
	else
	{
		enabled = true;
	}
}
void JFW_Domination_Zone::Timer_Expired(GameObject * obj,int number)
{
	enabled = true;
}
void JFW_Domination_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&currentmodelid);
	Auto_Save_Variable(2,1,&enabled);
	Auto_Save_Variable(3,4,&owner);
}
void JFW_Domination_Controler::Created(GameObject * obj)
{
	float timertime;
	int timernumber;
	gdizonecount = 0;
	nodzonecount = 0;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Domination_Controler::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int neutralmessage;
	int ownedmessage;
	neutralmessage = Get_Int_Parameter("NeutralMessage");
	ownedmessage = Get_Int_Parameter("OwnedMessage");
	if (message == ownedmessage)
	{
		if (param == 0)
		{
			gdizonecount--;
		}
		else
		{
			nodzonecount--;
		}
	}
	if ((message == neutralmessage) || (message == ownedmessage))
	{
		if (param == 1)
		{
			gdizonecount++;
		}
		else
		{
			nodzonecount++;
		}
	}
}
void JFW_Domination_Controler::Timer_Expired(GameObject * obj,int number)
{
	float timertime;
	int timernumber;
	float pointstogive;
	float pointstotake;
	GameObject *gdiobject;
	GameObject *nodobject;
	gdiobject = Commands->Find_Object(Get_Int_Parameter("GDIObjectID"));
	nodobject = Commands->Find_Object(Get_Int_Parameter("NodObjectID"));
	pointstogive = Get_Float_Parameter("PointsToGive");
	pointstotake = Get_Float_Parameter("PointsToTake");
	if (gdizonecount > 0)
	{
		if (pointstogive != 0)
		{
			Commands->Give_Points(gdiobject,pointstogive*gdizonecount,true);
		}
		if (pointstotake != 0)
		{
			Commands->Give_Points(nodobject,-(pointstotake*gdizonecount),true);
		}
	}
	if (nodzonecount > 0)
	{
		if (pointstogive != 0)
		{
			Commands->Give_Points(nodobject,pointstogive*nodzonecount,true);
		}
		if (pointstotake != 0)
		{
			Commands->Give_Points(gdiobject,-(pointstotake*nodzonecount),true);
		}
	}
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}
void JFW_Domination_Controler::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&gdizonecount);
	Auto_Save_Variable(2,4,&nodzonecount);
}
void JFW_3D_Sound_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	Vector3 v;
	const char *c;
	msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		v = Get_Vector3_Parameter("Position");
		c = Get_Parameter("Preset");
		Commands->Create_Sound(c,v,obj);
	}
}
void JFW_Object_Draw_In_Order::Created(GameObject * obj)
{
	currentmodelid = 0;
	currentmodelnumber = 1;
}
void JFW_Object_Draw_In_Order::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	Vector3 location;
	const char *basename;
	char name[20];
	int count;
	float facing;
	GameObject *object;
	msg = Get_Int_Parameter("Custom");
	if (message == msg)
	{
		if (currentmodelid != 0)
		{
			Commands->Destroy_Object(Commands->Find_Object(currentmodelid));
		}
		location = Get_Vector3_Parameter("location");
		basename = Get_Parameter("BaseName");
		count = Get_Int_Parameter("Count");
		facing = Get_Float_Parameter("Facing");
		sprintf(name,"%s%i",basename,currentmodelnumber);
		object = Commands->Create_Object("Generic_Cinematic",location);
		Commands->Enable_Hibernation(object,false);
		Commands->Add_To_Dirty_Cull_List(object);
		Commands->Set_Model(object,name);
		Commands->Set_Facing(object,facing);
		currentmodelid = Commands->Get_ID(object);
		currentmodelnumber++;
		if (currentmodelnumber > count)
		{
			currentmodelnumber = 1;
		}
	}
}
void JFW_Object_Draw_In_Order::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&currentmodelnumber);
	Auto_Save_Variable(2,4,&currentmodelid);
}
void JFW_Object_Draw_In_Order_2::Created(GameObject * obj)
{
	currentmodelid = 0;
	currentmodelnumber = Get_Int_Parameter("Start_Number");
}
void JFW_Object_Draw_In_Order_2::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	Vector3 location;
	const char *basename;
	char name[20];
	int count;
	float facing;
	GameObject *object;
	msg = Get_Int_Parameter("Custom");
	if (message == msg)
	{
		if (currentmodelid != 0)
		{
			Commands->Destroy_Object(Commands->Find_Object(currentmodelid));
		}
		location = Get_Vector3_Parameter("location");
		basename = Get_Parameter("BaseName");
		count = Get_Int_Parameter("Count");
		facing = Get_Float_Parameter("Facing");
		sprintf(name,"%s%i",basename,currentmodelnumber);
		object = Commands->Create_Object("Generic_Cinematic",location);
		Commands->Enable_Hibernation(object,false);
		Commands->Add_To_Dirty_Cull_List(object);
		Commands->Set_Model(object,name);
		Commands->Set_Facing(object,facing);
		currentmodelid = Commands->Get_ID(object);
		currentmodelnumber++;
		if (currentmodelnumber > count)
		{
			currentmodelnumber = Get_Int_Parameter("Start_Number");
		}
	}
}
void JFW_Object_Draw_In_Order_2::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&currentmodelnumber);
	Auto_Save_Variable(2,4,&currentmodelid);
}
void JFW_Object_Draw_Random::Created(GameObject * obj)
{
	currentmodelid = 0;
}
void JFW_Object_Draw_Random::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	Vector3 location;
	const char *basename;
	char name[20];
	int count;
	int currentmodelnumber;
	float facing;
	GameObject *object;
	msg = Get_Int_Parameter("Custom");
	if (message == msg)
	{
		if (currentmodelid != 0)
		{
			Commands->Destroy_Object(Commands->Find_Object(currentmodelid));
		}
		Commands->Destroy_Object(Commands->Find_Object(currentmodelid));
		location = Get_Vector3_Parameter("location");
		basename = Get_Parameter("BaseName");
		count = Get_Int_Parameter("Count");
		facing = Get_Float_Parameter("Facing");
		currentmodelnumber = Commands->Get_Random_Int(1,count);
		sprintf(name,"%s%i",basename,currentmodelnumber);
		object = Commands->Create_Object("Generic_Cinematic",location);
		Commands->Enable_Hibernation(object,false);
		Commands->Add_To_Dirty_Cull_List(object);
		Commands->Set_Model(object,name);
		Commands->Set_Facing(object,facing);
		currentmodelid = Commands->Get_ID(object);
	}
}
void JFW_Object_Draw_Random::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&currentmodelid);
}
void JFW_Weapon_Buy::Entered(GameObject * obj,GameObject * enter)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Weapon_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		Commands->Give_Money(enter,(float)cost,0);
		Commands->Give_Powerup(enter, preset, true);
	}
}
void JFW_Heal_Zone::Entered(GameObject * obj,GameObject * enter)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0)
	{
		return;
	}
	if (Commands->Is_A_Star(enter))
	{
		Commands->Start_Timer(obj,this,1.0,Commands->Get_ID(enter));
	}
}
void JFW_Heal_Zone::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Heal_Distance"))
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + Get_Float_Parameter("Heal_Health"));
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + Get_Float_Parameter("Heal_Health"));
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void JFW_Disable_Transitions_Zone::Entered(GameObject * obj,GameObject * enter)
{
	if (!Commands->Is_A_Star(enter))
	{
		Commands->Enable_Vehicle_Transitions(enter,false);
	}
}
void JFW_Disable_Transitions_Zone::Exited(GameObject * obj, GameObject * exit)
{
	if (!Commands->Is_A_Star(exit))
	{
		Commands->Enable_Vehicle_Transitions(exit,true);
	}
}
void JFW_Bounce_Zone_Entry_All_Directions::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	Vector3 pos;
	float angle;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	pos = Commands->Get_Position(enter);
	pos.Z += Get_Float_Parameter("ZAmount");
	angle = Commands->Get_Facing(obj);
	pos.X += Get_Float_Parameter("Amount")*(float)cos(angle);
	pos.Y += Get_Float_Parameter("Amount")*(float)sin(angle);
	Commands->Set_Position(enter,pos);
}
void JFW_Death_Destroy_Object::Killed(GameObject * obj,GameObject * shooter)
{
	Commands->Destroy_Object(Commands->Find_Object(Get_Int_Parameter("ID")));
}
void JFW_Drive_To_Player::Created(GameObject * obj)
{
	ActionParamsStruct params;
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,777,-1);
	params.Set_Goto(Commands->Get_A_Star(Commands->Get_Position(obj)),Get_Float_Parameter("Speed"),Get_Float_Parameter("Arrive_Distance"));
	Commands->Action_Goto(obj,params);
}
void JFW_Invulnerability_Timer::Created(GameObject * obj)
{
	enabled = true;
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Invulnerability_Time");
	timernumber = Get_Int_Parameter("Invulnerability_TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}
void JFW_Invulnerability_Timer::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if (enabled == true)
	{
		Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
		Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
	}
}
void JFW_Invulnerability_Timer::Timer_Expired(GameObject * obj,int number)
{
	if (number == Get_Int_Parameter("Invulnerability_TimerNum"))
	{
		enabled = false;
	}
}
void JFW_Invulnerability_Timer::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Iron_Curtain_Zone::Created(GameObject * obj)
{
	enabled = false;
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
}
void JFW_Iron_Curtain_Zone::Entered(GameObject * obj,GameObject * enter)
{
	char params[1000];
	float timertime;
	int timernumber;
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	int Player_Type = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,Player_Type) != 0) 
	{
		return;
	}
	if (enabled == false)
	{
		return;
	}
	if (!Commands->Is_A_Star(enter))
	{
		enabled = false;
		timertime = Get_Float_Parameter("Time");
		timernumber = Get_Int_Parameter("TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation2");
		position = Get_Vector3_Parameter("Animation2Loc");
		facing = Get_Float_Parameter("Animation2Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation2Slot"),Get_Int_Parameter("BuildingID"),0);
		sprintf(params,"%s,%s",Get_Parameter("Invunlerability_Time"),Get_Parameter("Invunlerability_TimerNum"));
		Commands->Attach_Script(enter,"JFW_Invulnerability_Timer",params);
	}
}
void JFW_Iron_Curtain_Zone::Killed(GameObject * obj,GameObject * shooter)
{
	if (enabled == true)
	{
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		const char *scriptname;
		Vector3 position;
		GameObject * object;
		float facing;
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
}
void JFW_Iron_Curtain_Zone::Timer_Expired(GameObject * obj,int number)
{
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	int num;
	num = Get_Int_Parameter("TimerNum");
	if (num == number)
	{
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation1");
		position = Get_Vector3_Parameter("Animation1Loc");
		facing = Get_Float_Parameter("Animation1Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation1Slot"),Get_Int_Parameter("BuildingID"),0);
		enabled = true;
	}
}
void JFW_Iron_Curtain_Zone::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	if (message == Get_Int_Parameter("Animation1Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),true);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
	}
	if (message == Get_Int_Parameter("Animation2Msg"))
	{
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
	if (message == Get_Int_Parameter("Animation3Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
	}
}
void JFW_Iron_Curtain_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Chrono_Controler_Zone::Created(GameObject * obj)
{
	enabled = false;
	activating = false;
	xpos = 0;
	ypos = 0;
	zpos = 0;
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Spawner_Time");
	timernumber = Get_Int_Parameter("Spawner_TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
	Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
}
void JFW_Chrono_Controler_Zone::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	float timertime;
	int timernumber;
	int msg = Get_Int_Parameter("Message");
	const char *scriptname;
	Vector3 position;
	GameObject *object;
	float facing;
	if (message == msg)
	{
		Vector3 pos = Commands->Get_Position(sender);
		xpos = pos.X;
		ypos = pos.Y;
		zpos = pos.Z;
		activating = true;
		timertime = Get_Float_Parameter("Activate_Time");
		timernumber = Get_Int_Parameter("Activate_TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
	if (message == Get_Int_Parameter("DeathMessage"))
	{
		activating = false;
	}
	if (message == Get_Int_Parameter("Animation1Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),true);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
	}
	if (message == Get_Int_Parameter("Animation2Msg"))
	{
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
	if (message == Get_Int_Parameter("Animation3Msg"))
	{
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
		Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),true);
		timertime = Get_Float_Parameter("Spawner_Time");
		timernumber = Get_Int_Parameter("Spawner_TimerNum");
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
}
void JFW_Chrono_Controler_Zone::Entered(GameObject * obj,GameObject * enter)
{
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	if (enabled == false)
	{
		return;
	}
	if (!Commands->Is_A_Star(enter))
	{
		enabled = false;
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation2");
		position = Get_Vector3_Parameter("Animation2Loc");
		facing = Get_Float_Parameter("Animation2Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation2Slot"),Get_Int_Parameter("BuildingID"),0);
		Vector3 pos;
		pos.X = xpos;
		pos.Y = ypos;
		pos.Z = zpos+Get_Float_Parameter("ZAdjust");
		Commands->Set_Position(enter,pos);
	}
}
void JFW_Chrono_Controler_Zone::Timer_Expired(GameObject * obj,int number)
{
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	int num;
	num = Get_Int_Parameter("Activate_TimerNum");
	if (num == number)
	{
		if (activating == true)
		{
			if (Get_Int_Parameter("CinematicPowerOff") == 1)
			{
				Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
				Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
			}
			scriptname = Get_Parameter("Animation1");
			position = Get_Vector3_Parameter("Animation1Loc");
			facing = Get_Float_Parameter("Animation1Facing");
			object = Commands->Create_Object("Invisible_Object",position);
			Commands->Set_Facing(object,facing);
			Commands->Attach_Script(object,"Test_Cinematic",scriptname);
			Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation1Slot"),Get_Int_Parameter("BuildingID"),0);
			enabled = true;
			float timertime;
			int timernumber;
			timertime = Get_Float_Parameter("Chrono_Time");
			timernumber = Get_Int_Parameter("Chrono_TimerNum");
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
	num = Get_Int_Parameter("Spawner_TimerNum");
	if (num == number)
	{
		Commands->Create_Object(Get_Parameter("Spawner_Preset"),Get_Vector3_Parameter("Spawner_Location"));
	}
	num = Get_Int_Parameter("Chrono_TimerNum");
	if ((num == number) && (enabled == true))
	{
		enabled = false;
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
}
void JFW_Chrono_Controler_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(2,4,&xpos);
	Auto_Save_Variable(3,4,&ypos);
	Auto_Save_Variable(4,4,&zpos);
	Auto_Save_Variable(5,1,&activating);
}
void JFW_Chrono_Controler_Zone::Killed(GameObject * obj,GameObject * shooter)
{
	if (enabled == true)
	{
		if (Get_Int_Parameter("CinematicPowerOff") == 1)
		{
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OnID")),false);
			Commands->Set_Is_Rendered(Commands->Find_Object(Get_Int_Parameter("OffID")),false);
		}
		const char *scriptname;
		Vector3 position;
		GameObject * object;
		float facing;
		scriptname = Get_Parameter("Animation3");
		position = Get_Vector3_Parameter("Animation3Loc");
		facing = Get_Float_Parameter("Animation3Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
		Commands->Send_Custom_Event(obj,object,10000+Get_Int_Parameter("Animation3Slot"),Get_Int_Parameter("BuildingID"),0);
	}
}
void JFW_Looping_Cinematic::Created(GameObject * obj)
{
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	int timernumber;
	float timertime;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
	scriptname = Get_Parameter("Script_Name");
	position = Get_Vector3_Parameter("Location");
	facing = Get_Float_Parameter("Facing");
	object = Commands->Create_Object("Invisible_Object",position);
	Commands->Set_Facing(object,facing);
	Commands->Attach_Script(object,"Test_Cinematic",scriptname);
}
void JFW_Looping_Cinematic::Timer_Expired(GameObject * obj,int number)
{
	const char *scriptname;
	Vector3 position;
	GameObject * object;
	float facing;
	int timernumber;
	float timertime;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (number == timernumber)
	{
		Commands->Start_Timer(obj,this,timertime,timernumber);
		scriptname = Get_Parameter("Script_Name");
		position = Get_Vector3_Parameter("Location");
		facing = Get_Float_Parameter("Facing");
		object = Commands->Create_Object("Invisible_Object",position);
		Commands->Set_Facing(object,facing);
		Commands->Attach_Script(object,"Test_Cinematic",scriptname);
	}
}
void JFW_Spawn_Object_Death_Enable::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Spawn_Object_Death_Enable::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("EnableMessage"))
	{
		enabled = true;
	}
	if (message == Get_Int_Parameter("DisableMessage"))
	{
		enabled = false;
	}
}
void JFW_Spawn_Object_Death_Enable::Killed(GameObject * obj,GameObject * shooter)
{
	if (enabled == true)
	{
		Vector3 spawn_location;
		float facing;
		float f;
		const char *c;
		GameObject *object;
		spawn_location = Commands->Get_Position(obj);
		facing = Commands->Get_Facing(obj);
		c = Get_Parameter("Drop_Object");
		f = Get_Float_Parameter("Drop_Height");
		spawn_location.Z = spawn_location.Z + f;
		object = Commands->Create_Object (c, spawn_location);
		Commands->Set_Facing(object,facing);
	}
}
void JFW_Spawn_Object_Death_Enable::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Spawn_Object_Death_Random::Killed(GameObject * obj,GameObject * shooter)
{
	int random = Commands->Get_Random_Int(0,100);
	if (random <= Get_Int_Parameter("Probobility"))
	{
		Vector3 spawn_location;
		float facing;
		float f;
		const char *c;
		GameObject *object;
		spawn_location = Commands->Get_Position(obj);
		facing = Commands->Get_Facing(obj);
		c = Get_Parameter("Drop_Object");
		f = Get_Float_Parameter("Drop_Height");
		spawn_location.Z = spawn_location.Z + f;
		object = Commands->Create_Object (c, spawn_location);
		Commands->Set_Facing(object,facing);
	}
}
void JFW_Spawn_Object_Death_Enable_Random::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Spawn_Object_Death_Enable_Random::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("EnableMessage"))
	{
		enabled = true;
	}
	if (message == Get_Int_Parameter("DisableMessage"))
	{
		enabled = false;
	}
}
void JFW_Spawn_Object_Death_Enable_Random::Killed(GameObject * obj,GameObject * shooter)
{
	int random = Commands->Get_Random_Int(0,100);
	if (random <= Get_Int_Parameter("Probobility"))
	{
		if (enabled == true)
		{
			Vector3 spawn_location;
			float facing;
			float f;
			const char *c;
			GameObject *object;
			spawn_location = Commands->Get_Position(obj);
			facing = Commands->Get_Facing(obj);
			c = Get_Parameter("Drop_Object");
			f = Get_Float_Parameter("Drop_Height");
			spawn_location.Z = spawn_location.Z + f;
			object = Commands->Create_Object (c, spawn_location);
			Commands->Set_Facing(object,facing);
		}
	}
}
void JFW_Spawn_Object_Death_Enable_Random::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Created_Send_Custom::Created(GameObject * obj)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),0,0);
}
void JFW_Damaged_Send_Custom::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),0,0);
}
void JFW_Enemy_Seen_Send_Custom::Created(GameObject * obj)
{
	Commands->Enable_Enemy_Seen(obj,true);
}
void JFW_Enemy_Seen_Send_Custom::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),Commands->Get_ID(seen),0);
}
void JFW_Create_Object_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		GameObject *obj = Commands->Create_Object(Get_Parameter("Object"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(obj,Get_Float_Parameter("Facing"));
	}
}
void JFW_Enable_Spawner_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Enable_Spawner(Get_Int_Parameter("ID"),Get_Int_Parameter("Enable"));
	}
}
void JFW_Set_Animation_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(obj,Get_Parameter("Animation"),Get_Int_Parameter("Loop"),subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Set_Model_Animation_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Set_Model(obj,Get_Parameter("Model"));
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(obj,Get_Parameter("Animation"),Get_Int_Parameter("Loop"),subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Set_Model_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Set_Model(obj,Get_Parameter("Model"));
	}
}
void JFW_Enable_Disable_Animation_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Enable"))
	{
		if (enabled == false)
		{
			enabled = true;
			const char *subobject = Get_Parameter("Subobject");
			if(stricmp(subobject,"0") == 0)
			{
				subobject = 0;
			}
			float firstframe = Get_Float_Parameter("FirstFrame");
			if (firstframe == -1)
			{
				firstframe = Get_Animation_Frame(obj);
			}
			Commands->Set_Animation(obj,Get_Parameter("Animation"),true,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
		}
	}
	if (message == Get_Int_Parameter("Disable"))
	{
		if (enabled == true)
		{
			const char *subobject = Get_Parameter("Subobject");
			if(stricmp(subobject,"0") == 0)
			{
				subobject = 0;
			}
			float firstframe = Get_Float_Parameter("FirstFrame");
			if (firstframe == -1)
			{
				firstframe = Get_Animation_Frame(obj);
			}
			Commands->Set_Animation(obj,Get_Parameter("Animation"),false,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
			enabled = false;
		}
	}
}
void JFW_Enable_Disable_Animation_On_Custom::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Enable_Disable_Animation_On_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}
void JFW_Vechicle_Animation::Timer_Expired(GameObject * obj,int number)
{
	Vector3 position = Commands->Get_Position(obj);
	if ((xpos == 0) && (ypos == 0) && (zpos == 0))
	{
		xpos = position.X;
		ypos = position.Y;
		zpos = position.Z;
	}
	if ((position.X != xpos) || (position.Y != ypos) || (position.Z != zpos))
	{
		xpos = position.X;
		ypos = position.Y;
		zpos = position.Z;
		if (enabled == false)
		{
			enabled = true;
			const char *subobject = Get_Parameter("Subobject");
			if(stricmp(subobject,"0") == 0)
			{
				subobject = 0;
			}
			float firstframe = Get_Float_Parameter("FirstFrame");
			if (firstframe == -1)
			{
				firstframe = Get_Animation_Frame(obj);
			}
			Commands->Set_Animation(obj,Get_Parameter("Animation"),true,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
		}
	}
	else 
	{
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(obj,Get_Parameter("Animation"),false,subobject,firstframe,firstframe,Get_Int_Parameter("Blended"));
		enabled = false;
	}
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Vechicle_Animation::Created(GameObject * obj)
{
	xpos = 0;
	ypos = 0;
	zpos = 0;
	enabled = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNum"));
}
void JFW_Vechicle_Animation::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(2,4,&xpos);
	Auto_Save_Variable(3,4,&ypos);
	Auto_Save_Variable(4,4,&zpos);
}
void JFW_Custom_Toggle_Visible::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Set_Is_Rendered(obj,Get_Int_Parameter("Visible"));
	}
}
void JFW_Visible_Person_In_Vechicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if ((message == CUSTOM_EVENT_VEHICLE_ENTER) && (modelid == 0))
	{
		Vector3 position = Commands->Get_Bone_Position(obj,Get_Parameter("BoneName"));
		GameObject *object = Commands->Create_Object("Generic_Cinematic",position);
		Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName"));
		Commands->Set_Model(object,Get_Parameter("ModelName"));
		modelid = Commands->Get_ID(object);
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(object,Get_Parameter("Animation"),true,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid));
		modelid = 0;
	}
}
void JFW_Visible_Person_In_Vechicle::Created(GameObject * obj)
{
	modelid = 0;
}
void JFW_Visible_Person_In_Vechicle::Killed(GameObject * obj,GameObject * shooter)
{
	if (modelid != 0)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid));
	}
}
void JFW_Visible_Person_In_Vechicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&modelid);
}
void JFW_Visible_People_In_Vechicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (modelid1 == 0)
		{
			Vector3 position = Commands->Get_Bone_Position(obj,Get_Parameter("BoneName1"));
			GameObject *object = Commands->Create_Object("Generic_Cinematic",position);
			Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName1"));
			Commands->Set_Model(object,Get_Parameter("ModelName1"));
			modelid1 = Commands->Get_ID(object);
			const char *subobject = Get_Parameter("Subobject1");
			if(stricmp(subobject,"0") == 0)
			{
				subobject = 0;
			}
			float firstframe = Get_Float_Parameter("FirstFrame1");
			if (firstframe == -1)
			{
				firstframe = Get_Animation_Frame(obj);
			}
			Commands->Set_Animation(object,Get_Parameter("Animation1"),true,subobject,firstframe,Get_Float_Parameter("LastFrame1"),Get_Int_Parameter("Blended1"));
		}
		else
		{
			if (modelid2 == 0)
			{
				Vector3 position = Commands->Get_Bone_Position(obj,Get_Parameter("BoneName2"));
				GameObject *object = Commands->Create_Object("Generic_Cinematic",position);
				Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName2"));
				Commands->Set_Model(object,Get_Parameter("ModelName2"));
				modelid2 = Commands->Get_ID(object);
				const char *subobject = Get_Parameter("Subobject2");
				if(stricmp(subobject,"0") == 0)
				{
					subobject = 0;
				}
				float firstframe = Get_Float_Parameter("FirstFrame2");
				if (firstframe == -1)
				{
					firstframe = Get_Animation_Frame(obj);
				}
				Commands->Set_Animation(object,Get_Parameter("Animation2"),true,subobject,firstframe,Get_Float_Parameter("LastFrame2"),Get_Int_Parameter("Blended2"));
			}
		}
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (modelid2 != 0)
		{
			Commands->Destroy_Object(Commands->Find_Object(modelid2));
			modelid2 = 0;
		}
		else
		{
			if (modelid1 != 0)
			{
				Commands->Destroy_Object(Commands->Find_Object(modelid1));
				modelid1 = 0;
			}
		}
	}
}
void JFW_Visible_People_In_Vechicle::Created(GameObject * obj)
{
	modelid1 = 0;
	modelid2 = 0;
}
void JFW_Visible_People_In_Vechicle::Killed(GameObject * obj,GameObject * shooter)
{
	if (modelid1 != 0)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid1));
	}
	if (modelid2 != 0)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid2));
	}
}
void JFW_Visible_People_In_Vechicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&modelid1);
	Auto_Save_Variable(2,4,&modelid2);
}
void JFW_Blow_Up_On_Enter_Random::Entered(GameObject * obj,GameObject * enter)
{
	int random = Commands->Get_Random_Int(0,100);
	if (random <= Get_Int_Parameter("Probobility"))
	{
		const char *c;
		Vector3 v;
		c = Get_Parameter("Explosion");
		v = Commands->Get_Position(enter);
		Commands->Create_Explosion(c,v,0);
	}
}
void JFW_Zone_Send_Custom_Cost::Entered(GameObject * obj,GameObject * enter)
{
	GameObject * object;
	int message;
	int ID;
	int param;
	int pltype;
	int cost;
	pltype = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,pltype) != 0)
	{
		return;
	}
	ID = Get_Int_Parameter("ID");
	message = Get_Int_Parameter("Message");
	param = Get_Int_Parameter("Param");
	object = Commands->Find_Object(ID);
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(enter))
	{
		cost = -cost;
		Commands->Give_Money(enter,(float)cost,0);
		if (param == 0)
		{
			param = Commands->Get_ID(enter);
		}
		Commands->Send_Custom_Event(obj,object,message,param,0);
	}
}
void JFW_Engineer_Target::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&repairid);
	Auto_Save_Variable(2,4,&health);
	Auto_Save_Variable(3,4,&shieldstrength);
}
void JFW_Engineer_Target::Created(GameObject * obj)
{
	health = Commands->Get_Health(obj);
	shieldstrength = Commands->Get_Shield_Strength(obj);
}
void JFW_Engineer_Target::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == 40011)
	{
		repairid = param;
	}
}
void JFW_Engineer_Target::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	Vector3 position;
	position = Commands->Get_Position(obj);
	Commands->Create_Logical_Sound(obj,40012,position,150);
	Commands->Start_Timer(obj,this,3.0,40013);
}
void JFW_Engineer_Target::Destroyed(GameObject * obj)
{
	Vector3 position;
	position = Commands->Get_Position(obj);
	Commands->Create_Logical_Sound(obj,40014,position,150);
}
void JFW_Engineer_Target::Timer_Expired(GameObject * obj,int number)
{
	float currenthealth;
	float currentshieldstrength;
	Vector3 position;
	if (number == 40013)
	{
		currenthealth = Commands->Get_Health(obj);
		currentshieldstrength = Commands->Get_Shield_Strength(obj);
		if ((currenthealth == health) && (currentshieldstrength == shieldstrength))
		{
			position = Commands->Get_Position(obj);
			Commands->Create_Logical_Sound(obj,40014,position,150);
		}
		if ((currenthealth != health) || (currentshieldstrength != shieldstrength))
		{
			position = Commands->Get_Position(obj);
			Commands->Create_Logical_Sound(obj,40012,position,150);
			Commands->Start_Timer(obj,this,3.0,40013);
		}
	}
}
void JFW_Engineer_Repair::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
	Auto_Save_Variable(2,4,&repairid);
	Auto_Save_Variable(3,4,&targetid);
	Auto_Save_Variable(4,4,&priority);
}
void JFW_Engineer_Repair::Created(GameObject * obj)
{
	active = false;
	priority = Get_Int_Parameter("Repair_Priority");
}
void JFW_Engineer_Repair::Sound_Heard(GameObject * obj,const CombatSound & sound)
{
	ActionParamsStruct params;
	if ((sound.sound == 40012) && (active == false) && (Commands->Get_Player_Type(sound.obj) == Commands->Get_Player_Type(obj)))
	{
		repairid = Commands->Get_ID(obj);
		targetid = Commands->Get_ID(sound.obj);
		Commands->Send_Custom_Event(obj,sound.obj,40011,repairid,0);
		active = true;
		params.Set_Basic(this,priority,40015,-1);
		params.Set_Goto_Location(Commands->Get_Position(sound.obj),(float)0.8,(float)5.0,0);
		Commands->Action_Goto(obj,params);
	}
	else
	{
		if ((sound.sound == 40014) && (targetid == Commands->Get_ID(sound.obj)))
		{
			Commands->Action_Reset(obj,100);
			active = false;
		}
	}
}
void JFW_Engineer_Repair::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	ActionParamsStruct params;
	if (action == 40015)
	{
		params.Set_Basic(this,priority,40016,-1);
		params.Set_Attack_Hold(Commands->Find_Object(targetid),50,0,false,false);
		Commands->Action_Attack(obj,params);
	}
}
void JFW_Vechicle_Damage_Zone::Entered(GameObject * obj,GameObject * enter)
{
	if (!Commands->Is_A_Star(enter))
	{
		int Player_Type = Get_Int_Parameter("Player_Type");
		if (CheckPlayerType(enter,Player_Type) != 0)
		{
			return;
		}
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Commands->Get_ID(enter));
	}
}
void JFW_Vechicle_Damage_Zone::Timer_Expired(GameObject * obj,int number)
{
	float f;
	const char *w;
	float distance;
	Vector3 pos1;
	Vector3 pos2;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= Get_Float_Parameter("Distance"))
	{
		w = Get_Parameter("Warhead");
		f = Get_Float_Parameter("Damage");
		Commands->Apply_Damage(Commands->Find_Object(number),f,w,0);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),number);
	}
}
void JFW_Cinematic_Attack::Created(GameObject * obj)
{
	ActionParamsStruct params;
	int priority = Get_Int_Parameter("Priority");
	int targetid = Get_Int_Parameter("ID");
	float range = Get_Float_Parameter("Range");
	float deviation = Get_Float_Parameter("Deviation");
	int primary = Get_Int_Parameter("Primary");
	params.Set_Basic(this,priority,40016,-1);
	params.Set_Attack_Hold(Commands->Find_Object(targetid),range,deviation,primary,false);
	Commands->Action_Attack(obj,params);
}
void JFW_Cinematic_Attack::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	Commands->Action_Reset(obj,100);
}
void JFW_Customs_Send_Custom::Created(GameObject * obj)
{
	if (Get_Int_Parameter("Message1") == 0)
	{
		custom1 = true;
	}
	else
	{
		custom1 = false;
	}
	if (Get_Int_Parameter("Message2") == 0)
	{
		custom2 = true;
	}
	else
	{
		custom2 = false;
	}
	if (Get_Int_Parameter("Message3") == 0)
	{
		custom3 = true;
	}
	else
	{
		custom3 = false;
	}
	if (Get_Int_Parameter("Message4") == 0)
	{
		custom4 = true;
	}
	else
	{
		custom4 = false;
	}
	if (Get_Int_Parameter("Message5") == 0)
	{
		custom5 = true;
	}
	else
	{
		custom5 = false;
	}
	if (Get_Int_Parameter("Message6") == 0)
	{
		custom6 = true;
	}
	else
	{
		custom6 = false;
	}
	if (Get_Int_Parameter("Message7") == 0)
	{
		custom7 = true;
	}
	else
	{
		custom7 = false;
	}
	if (Get_Int_Parameter("Message8") == 0)
	{
		custom8 = true;
	}
	else
	{
		custom8 = false;
	}
	trigger = false;
}
void JFW_Customs_Send_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Message1");
	if (message == msg)
	{
		custom1 = true;
	}
	msg = Get_Int_Parameter("Message2");
	if (message == msg)
	{
		custom2 = true;
	}
	msg = Get_Int_Parameter("Message3");
	if (message == msg)
	{
		custom3 = true;
	}
	msg = Get_Int_Parameter("Message4");
	if (message == msg)
	{
		custom4 = true;
	}
	msg = Get_Int_Parameter("Message5");
	if (message == msg)
	{
		custom5 = true;
	}
	msg = Get_Int_Parameter("Message6");
	if (message == msg)
	{
		custom6 = true;
	}
	msg = Get_Int_Parameter("Message7");
	if (message == msg)
	{
		custom7 = true;
	}
	msg = Get_Int_Parameter("Message8");
	if (message == msg)
	{
		custom8 = true;
	}
	if (trigger == false)
	{
		if ((custom1 == true) && (custom2 == true) && (custom3 == true) && (custom4 == true) && (custom5 == true) && (custom6 == true) && (custom7 == true) && (custom8 == true))
		{
			trigger = true;
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),Get_Int_Parameter("Param"),0);
		}
	}
}
void JFW_Customs_Send_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&custom1);
	Auto_Save_Variable(2,1,&custom2);
	Auto_Save_Variable(3,1,&custom3);
	Auto_Save_Variable(4,1,&custom4);
	Auto_Save_Variable(5,1,&custom5);
	Auto_Save_Variable(6,1,&custom6);
	Auto_Save_Variable(7,1,&custom7);
	Auto_Save_Variable(8,1,&custom8);
	Auto_Save_Variable(9,1,&trigger);
}
void JFW_Custom_Multiple_Send_Custom::Created(GameObject * obj)
{
	times_recieved = 0;
	enabled = true;
}
void JFW_Custom_Multiple_Send_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (enabled == true)
	{
		if (message == Get_Int_Parameter("RecieveMessage"))
		{
			times_recieved++;
		}
		if (times_recieved == Get_Int_Parameter("RecieveCount"))
		{
			enabled = false;
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
		}
	}
}
void JFW_Custom_Multiple_Send_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&times_recieved);
	Auto_Save_Variable(2,1,&enabled);
}
void JFW_Custom_Send_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("RecieveMessage"))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
	}
}
void JFW_Create_Destroy_Object_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("CreateMessage"))
	{
		GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
		ObjectID = Commands->Get_ID(object);
	}
	if (message == Get_Int_Parameter("DestroyMessage"))
	{
		Commands->Destroy_Object(Commands->Find_Object(ObjectID));
		ObjectID = 0;
	}
}
void JFW_Create_Destroy_Object_On_Custom::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
void JFW_Create_Destroy_Object_On_Custom_Animate::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("CreateMessage"))
	{
		GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
		ObjectID = Commands->Get_ID(object);
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(object,Get_Parameter("Animation"),Get_Int_Parameter("Loop"),subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
	if (message == Get_Int_Parameter("DestroyMessage"))
	{
		Commands->Destroy_Object(Commands->Find_Object(ObjectID));
		ObjectID = 0;
	}
}
void JFW_Create_Destroy_Object_On_Custom_Animate::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Custom_Animate::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
void JFW_Create_Destroy_Object_On_Custom_Animate_2::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int timernumber;
	float timertime;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	if (message == Get_Int_Parameter("CreateMessage"))
	{
		GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
		ObjectID = Commands->Get_ID(object);
		const char *subobject = Get_Parameter("CreateSubobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("CreateFirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(object,Get_Parameter("CreateAnimation"),Get_Int_Parameter("CreateLoop"),subobject,firstframe,Get_Float_Parameter("CreateLastFrame"),Get_Int_Parameter("CreateBlended"));
	}
	if (message == Get_Int_Parameter("DestroyMessage"))
	{
		const char *subobject = Get_Parameter("DestroySubobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("DestroyFirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(Commands->Find_Object(ObjectID),Get_Parameter("DestroyAnimation"),false,subobject,firstframe,Get_Float_Parameter("DestroyLastFrame"),Get_Int_Parameter("DestroyBlended"));
		Commands->Start_Timer(obj,this,timertime,timernumber);
	}
}
void JFW_Create_Destroy_Object_On_Custom_Animate_2::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Custom_Animate_2::Timer_Expired(GameObject * obj,int number)
{
	if (number == Get_Int_Parameter("TimerNum"))
	{
		Commands->Destroy_Object(Commands->Find_Object(ObjectID));
		ObjectID = 0;
	}
}
void JFW_Create_Destroy_Object_On_Custom_Animate_2::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
void JFW_Damaged_Send_Custom_Amount::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if (damage < Get_Float_Parameter("Damage"))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message1"),0,0);
	}
	else
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message2"),0,0);
	}
}
void JFW_Invulnerable_On_Custom::Created(GameObject * obj)
{
	enabled = false;
}
void JFW_Invulnerable_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		if (param == 1)
		{
			enabled = true;
			health = Commands->Get_Health(obj);
			shield_strength = Commands->Get_Shield_Strength(obj);
			float maxhealth = Commands->Get_Max_Health(obj);
			float maxshieldstrength = Commands->Get_Max_Shield_Strength(obj);
			Commands->Set_Health(obj,maxhealth);
			Commands->Set_Shield_Strength(obj,maxshieldstrength);
		}
		else
		{
			enabled = false;
			Commands->Set_Health(obj,health);
			Commands->Set_Shield_Strength(obj,shield_strength);
		}
	}
}
void JFW_Invulnerable_On_Custom_2::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		if (param == 1)
		{
			Commands->Set_Shield_Type(obj,Get_Parameter("InvulnerableArmour"));
		}
		else
		{
			Commands->Set_Shield_Type(obj,Get_Parameter("NormalArmour"));
		}
	}
}
void JFW_Invulnerable_On_Custom::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if (enabled == true)
	{
		Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
		Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
	}
}
void JFW_Invulnerable_On_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
	Auto_Save_Variable(2,4,&health);
	Auto_Save_Variable(3,4,&shield_strength);
}
void JFW_Per_Preset_Visible_Person_In_Vechicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if ((message == CUSTOM_EVENT_VEHICLE_ENTER) && (modelid == 0))
	{
		//Code added by NeoSaber
		//This is to destroy the object incase it still 
		//remained for whatever reason
		if(modelid != 0)
			Commands->Destroy_Object(Commands->Find_Object(modelid));
		//End Code added by NeoSaber

		Vector3 position = Commands->Get_Bone_Position(obj,Get_Parameter("BoneName"));
		GameObject *object = Commands->Create_Object("Generic_Cinematic",position);
		Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName"));
		Commands->Send_Custom_Event(obj,sender,Get_Int_Parameter("Message"),Commands->Get_ID(object),0);
		modelid = Commands->Get_ID(object);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid));
		modelid = 0;
	}
}
void JFW_Per_Preset_Visible_Person_In_Vechicle::Created(GameObject * obj)
{
	modelid = 0;
}
void JFW_Per_Preset_Visible_Person_In_Vechicle::Killed(GameObject * obj,GameObject * shooter)
{
	if (modelid != 0)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid));
	}
}
void JFW_Per_Preset_Visible_Person_In_Vechicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&modelid);
}
void JFW_Per_Preset_Visible_People_In_Vechicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (modelid1 == 0)
		{
			Vector3 position = Commands->Get_Bone_Position(obj,Get_Parameter("BoneName1"));
			GameObject *object = Commands->Create_Object("Generic_Cinematic",position);
			Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName1"));
			Commands->Send_Custom_Event(obj,sender,Get_Int_Parameter("Message1"),Commands->Get_ID(object),0);
			modelid1 = Commands->Get_ID(object);
		}
		else
		{
			if (modelid2 == 0)
			{
				Vector3 position = Commands->Get_Bone_Position(obj,Get_Parameter("BoneName2"));
				GameObject *object = Commands->Create_Object("Generic_Cinematic",position);
				Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName2"));
				Commands->Send_Custom_Event(obj,sender,Get_Int_Parameter("Message2"),Commands->Get_ID(object),0);
				modelid2 = Commands->Get_ID(object);
			}
		}
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (modelid2 != 0)
		{
			Commands->Destroy_Object(Commands->Find_Object(modelid2));
			modelid2 = 0;
		}
		else
		{
			if (modelid1 != 0)
			{
				Commands->Destroy_Object(Commands->Find_Object(modelid1));
				modelid1 = 0;
			}
		}
	}
}
void JFW_Per_Preset_Visible_People_In_Vechicle::Created(GameObject * obj)
{
	modelid1 = 0;
	modelid2 = 0;
}
void JFW_Per_Preset_Visible_People_In_Vechicle::Killed(GameObject * obj,GameObject * shooter)
{
	if (modelid1 != 0)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid1));
	}
	if (modelid2 != 0)
	{
		Commands->Destroy_Object(Commands->Find_Object(modelid2));
	}
}
void JFW_Per_Preset_Visible_People_In_Vechicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&modelid1);
	Auto_Save_Variable(2,4,&modelid2);
}
void JFW_Visible_Person_Settings::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		GameObject *object = Commands->Find_Object(param);
		Commands->Set_Model(object,Get_Parameter("ModelName"));
		const char *subobject = Get_Parameter("Subobject");
		if(stricmp(subobject,"0") == 0)
		{
			subobject = 0;
		}
		float firstframe = Get_Float_Parameter("FirstFrame");
		if (firstframe == -1)
		{
			firstframe = Get_Animation_Frame(obj);
		}
		Commands->Set_Animation(object,Get_Parameter("Animation"),true,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
	}
}
void JFW_Play_Animation_Destroy_Object::Created(GameObject * obj)
{
	const char *subobject = Get_Parameter("Subobject");
	if(stricmp(subobject,"0") == 0)
	{
		subobject = 0;
	}
	float firstframe = Get_Float_Parameter("FirstFrame");
	if (firstframe == -1)
	{
		firstframe = Get_Animation_Frame(obj);
	}
	Commands->Set_Animation(obj,Get_Parameter("Animation"),false,subobject,firstframe,Get_Float_Parameter("LastFrame"),Get_Int_Parameter("Blended"));
}
void JFW_Play_Animation_Destroy_Object::Animation_Complete(GameObject * obj,const char *anim)
{
	Commands->Destroy_Object(obj);
}
void JFW_Custom_Send_Custom_Parameter::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int basemessage = Get_Int_Parameter("BaseMessage");
	int limit = Get_Int_Parameter("Limit");
	int ID = Get_Int_Parameter("ID");
	if ((message >= basemessage) && (message <= limit))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(ID),basemessage,message-basemessage,0);
	}
}
void JFW_Create_Destroy_Object_On_Custom_Bone::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("CreateMessage"))
	{
		GameObject *object = Commands->Create_Object(Get_Parameter("Preset"),Get_Vector3_Parameter("Location"));
		Commands->Set_Facing(object,Get_Float_Parameter("Facing"));
		Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("BoneName"));
		ObjectID = Commands->Get_ID(object);
	}
	if (message == Get_Int_Parameter("DestroyMessage"))
	{
		Commands->Destroy_Object(Commands->Find_Object(ObjectID));
	}
}
void JFW_Create_Destroy_Object_On_Custom_Bone::Created(GameObject * obj)
{
	ObjectID = 0;
}
void JFW_Create_Destroy_Object_On_Custom_Bone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&ObjectID);
}
ScriptRegistrant<JFW_Customs_Play_Cinematic> JFW_Customs_Play_Cinematic_Registrant("JFW_Customs_Play_Cinematic","Message1:int,Message2:int,Message3:int,Message4:int,Message5:int,Message6:int,Message7:int,Message8:int,Script_Name:string,Location:Vector3,Facing:float");
ScriptRegistrant<JFW_Armour_Regen> JFW_Armour_Regen_Registrant("JFW_Armour_Regen","Time:float,TimerNum:int,Points:float");
ScriptRegistrant<JFW_Health_Regen> JFW_Health_Regen_Registrant("JFW_Health_Regen","Time:float,TimerNum:int,Points:float");
ScriptRegistrant<JFW_Turret_Spawn_2> JFW_Turret_Spawn_2_Registrant ("JFW_Turret_Spawn_2","Turret_Preset:string,Bone_Name=Tur_Mount:string,Explosion_Preset:string,Explosion_Bone:string");
ScriptRegistrant<JFW_Zone_Send_Custom_Not_Preset> JFW_Zone_Send_Custom_Not_Preset_Registrant("JFW_Zone_Send_Custom_Not_Preset","ID:int,EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Player_Type:int,Preset_Name:string");
ScriptRegistrant<JFW_Zone_Send_Custom_Keycard> JFW_Zone_Send_Custom_Keycard("JFW_Zone_Send_Custom_Keycard","ID:int,EnterMessage:int,EnterParam:int,ExitMessage:int,ExitParam:int,Player_Type:int,Keycard_Number:int");
ScriptRegistrant<JFW_Apply_Damage_On_Enter_Timer> JFW_Apply_Damage_On_Enter_Timer_Registrant("JFW_Apply_Damage_On_Enter_Timer","Warhead:string,Damage:float,Time:float,Distance:float,Player_Type:int");
ScriptRegistrant<JFW_Give_Points_On_Death> JFW_Give_Points_On_Death_Registrant("JFW_Give_Points_On_Death","Points:float,Player_Type:int,Whole_Team:int");
ScriptRegistrant<JFW_Teleport_Custom> JFW_Teleport_Custom_Registrant("JFW_Teleport_Custom","Location:Vector3,Object_ID=0:int,Message:int");
ScriptRegistrant<JFW_Teleport_Custom_Random> JFW_Teleport_Custom_Random_Registrant("JFW_Teleport_Custom_Random","Location1:Vector3,Object_ID1=0:int,Location2:Vector3,Object_ID2=0:int,Location3:Vector3,Object_ID3=0:int,Location4:Vector3,Object_ID4=0:int,Location5:Vector3,Object_ID5=0:int,Message:int");
ScriptRegistrant<JFW_Teleport_Custom_Timer> JFW_Teleport_Custom_Timer_Registrant("JFW_Teleport_Custom_Timer","Location:Vector3,Object_ID=0:int,Message:int,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Blow_Up_Location_On_Custom> JFW_Blow_Location_Up_On_Custom_Registrant("JFW_Blow_Location_Up_On_Custom","Explosion:string,Message:int,Location:Vector3");
ScriptRegistrant<JFW_Domination_Zone> JFW_Domination_Zone_Registrant("JFW_Domination_Zone","Controler_ID:int,NeutralMessage:int,OwnedMessage:int,Nod_Model:string,GDI_Model:string,Neutral_Model:string,Capture_Delay_Time:float,TimerNum:int");
ScriptRegistrant<JFW_Domination_Controler> JFW_Domination_Controler_Registrant("JFW_Domination_Controler","NeutralMessage:int,OwnedMessage:int,Time:float,TimerNum:int,PointsToGive:float,PointsToTake:float,GDIObjectID:int,NodObjectID:int");
ScriptRegistrant<JFW_3D_Sound_Custom> JFW_3D_Sound_Custom_Registrant("JFW_3D_Sound_Custom","Message:int,Preset:string,Position:Vector3");
ScriptRegistrant<JFW_Object_Draw_In_Order> JFW_Object_Draw_In_Order_Registrant("JFW_Object_Draw_In_Order"," Location:Vector3,Custom:int,BaseName:string,Count:int,Facing:float");
ScriptRegistrant<JFW_Object_Draw_In_Order_2> JFW_Object_Draw_In_Order_2_Registrant("JFW_Object_Draw_In_Order_2"," Location:Vector3,Custom:int,BaseName:string,Count:int,Facing:float,Start_Number:int");
ScriptRegistrant<JFW_Object_Draw_Random> JFW_Object_Draw_Random_Registrant("JFW_Object_Draw_Random"," Location:Vector3,Custom:int,BaseName:string,Count:int,Facing:float");
ScriptRegistrant<JFW_Weapon_Buy> JFW_Weapon_Buy_Registrant("JFW_Weapon_Buy","Weapon_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Heal_Zone> JFW_Heal_Zone_Registrant("JFW_Heal_Zone","Player_Type:int,Heal_Distance:float,Heal_Health:float");
ScriptRegistrant<JFW_Disable_Transitions_Zone> JFW_Disable_Transitions_Zone_Registrant("JFW_Disable_Transitions_Zone","");
ScriptRegistrant<JFW_Bounce_Zone_Entry_All_Directions> JFW_Bounce_Zone_Entry_All_Directions_Registrant("JFW_Bounce_Zone_Entry_All_Directions","Player_Type:int,ZAmount:float,Amount:float");
ScriptRegistrant<JFW_Death_Destroy_Object> JFW_Death_Destroy_Object_Registrant("JFW_Death_Destroy_Object","ID:int");
ScriptRegistrant<JFW_Drive_To_Player> JFW_Drive_To_Player_Registrant("JFW_Drive_To_Player","Speed:float,Arrive_Distance:float");
ScriptRegistrant<JFW_Invulnerability_Timer> JFW_Invulnerability_Timer_Registrant("JFW_Invulnerability_Timer","Invulnerability_Time:float,Invulnerability_TimerNum:int");
ScriptRegistrant<JFW_Iron_Curtain_Zone> JFW_Iron_Curtain_Zone_Registrant("JFW_Iron_Curtain_Zone","Time:float,TimerNum:int,Animation1:string,Animation1Loc:Vector3,Animation1Facing:float,Animation1Slot:int,Animation2:string,Animation2Loc:Vector3,Animation2Facing:float,Animation2Slot:int,Player_Type:int,Animation3:string,Animation3Loc:Vector3,Animation3Facing:float,Animation3Slot:int,BuildingID:int,Invunlerability_Time:float,Invunlerability_TimerNum:int,Animation1Msg:int,Animation2Msg:int,Animation3Msg:int,OffID:int,OnID:int,CinematicPowerOff:int");
ScriptRegistrant<JFW_Chrono_Controler_Zone> JFW_Chrono_Controler_Zone_Registrant("JFW_Chrono_Controler_Zone","Spawner_Time:float,Spawner_TimerNum:int,Spawner_Preset:string,Spawner_Location:Vector3,Chrono_Time:float,Chrono_TimerNum:int,Message:int,Animation1:string,Animation1Loc:Vector3,Animation1Facing:float,Animation1Slot:int,Animation2:string,Animation2Loc:Vector3,Animation2Facing:float,Animation2Slot:int,Animation3:string,Animation3Loc:Vector3,Animation3Facing:float,Animation3Slot:int,BuildingID:int,ZAdjust:float,Animation1Msg:int,Animation2Msg:int,Animation3Msg:int,OffID:int,OnID:int,CinematicPowerOff:int,Activate_Time:float,Activate_TimerNum:int,DeathMessage:int");
ScriptRegistrant<JFW_Looping_Cinematic> JFW_Looping_Cinematic_Registrant("JFW_Looping_Cinematic","Script_Name:string,Location:Vector3,Facing:float,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Spawn_Object_Death_Enable> JFW_Spawn_Object_Death_Enable_Registrant("JFW_Spawn_Object_Death_Enable","Drop_Object:string,Drop_Height:float,EnableMessage:int,DisableMessage:int");
ScriptRegistrant<JFW_Spawn_Object_Death_Enable_Random> JFW_Spawn_Object_Death_Enable_Random_Registrant("JFW_Spawn_Object_Death_Enable_Random","Drop_Object:string,Drop_Height:float,EnableMessage:int,DisableMessage:int,Probobility:int");
ScriptRegistrant<JFW_Spawn_Object_Death_Random> JFW_Spawn_Object_Death_Random_Registrant("JFW_Spawn_Object_Death_Random","Drop_Object:string,Drop_Height:float,Probobility:int");
ScriptRegistrant<JFW_Created_Send_Custom> JFW_Created_Send_Custom_Registrant("JFW_Created_Send_Custom","ID:int,Message:int");
ScriptRegistrant<JFW_Damaged_Send_Custom> JFW_Damaged_Send_Custom_Registrant("JFW_Damaged_Send_Custom","ID:int,Message:int");
ScriptRegistrant<JFW_Enemy_Seen_Send_Custom> JFW_Enemy_Seen_Send_Custom_Registrant("JFW_Enemy_Seen_Send_Custom","ID:int,Message:int");
ScriptRegistrant<JFW_Create_Object_Custom> JFW_Create_Object_Custom_Registrant("JFW_Create_Object_Custom","Object:string,Location:Vector3,Facing:float,Message:int");
ScriptRegistrant<JFW_Enable_Spawner_On_Custom> JFW_Enable_Spawner_On_Custom_Registrant("JFW_Enable_Spawner_On_Custom","ID:int,Enable:int,Message:int");
ScriptRegistrant<JFW_Set_Animation_On_Custom> JFW_Set_Animation_On_Custom_Registrant("JFW_Set_Animation_On_Custom","Animation:string,Loop:int,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Message:int");
ScriptRegistrant<JFW_Set_Model_Animation_On_Custom> JFW_Set_Model_Animation_On_Custom_Registrant("JFW_Set_Model_Animation_On_Custom","Animation:string,Loop:int,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Model:string,Message:int");
ScriptRegistrant<JFW_Set_Model_On_Custom> JFW_Set_Model_On_Custom_Registrant("JFW_Set_Model_On_Custom","Model:string,Message:int");
ScriptRegistrant<JFW_Enable_Disable_Animation_On_Custom> JFW_Enable_Disable_Animation_On_Custom_Registrant("JFW_Enable_Disable_Animation_On_Custom","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Enable:int,Disable:int");
ScriptRegistrant<JFW_Vechicle_Animation> JFW_Vechicle_Animation_Registrant("JFW_Vechicle_Animation","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Custom_Toggle_Visible> JFW_Custom_Toggle_Visible_Registrant("JFW_Custom_Toggle_Visible","Message:int,Visible:int");
ScriptRegistrant<JFW_Visible_Person_In_Vechicle> JFW_Visible_Person_In_Vechicle_Registrant("JFW_Visible_Person_In_Vechicle","BoneName:string,ModelName:string,Animation:string,SubObject:string,FirstFrame:float,LastFrame:float,Blended:int");
ScriptRegistrant<JFW_Visible_People_In_Vechicle> JFW_Visible_People_In_Vechicle_Registrant("JFW_Visible_People_In_Vechicle","BoneName1:string,ModelName1:string,Animation1:string,SubObject1:string,FirstFrame1:float,LastFrame1:float,Blended1:int,BoneName2:string,ModelName2:string,Animation2:string,SubObject2:string,FirstFrame2:float,LastFrame2:float,Blended2:int");
ScriptRegistrant<JFW_Blow_Up_On_Enter_Random> JFW_Blow_Up_On_Enter_Random_Registrant("JFW_Blow_Up_On_Enter_Random","Explosion:string,Probobility:int");
ScriptRegistrant<JFW_Zone_Send_Custom_Cost> JFW_Zone_Send_Custom_Cost_Registrant("JFW_Zone_Send_Custom_Cost","ID:int,Message:int,Param:int,Player_Type:int,Cost:int");
ScriptRegistrant<JFW_Engineer_Target> JFW_Engineer_Target_Registrant("JFW_Engineer_Target","");
ScriptRegistrant<JFW_Engineer_Repair> JFW_Engineer_Repair_Registrant("JFW_Engineer_Repair","Repair_Priority=96:int");
ScriptRegistrant<JFW_Vechicle_Damage_Zone> JFW_Vechicle_Damage_Zone_Registrant("JFW_Vechicle_Damage_Zone","Warhead:string,Damage:float,Time:float,Distance:float,Player_Type:int");
ScriptRegistrant<JFW_Cinematic_Attack> JFW_Cinematic_Attack_Registrant("JFW_Cinematic_Attack","Priority=96:int,ID:int,Range:float,Deviation:float,Primary:int");
ScriptRegistrant<JFW_Customs_Send_Custom> JFW_Customs_Send_Custom_Registrant("JFW_Customs_Send_Custom","Message1:int,Message2:int,Message3:int,Message4:int,Message5:int,Message6:int,Message7:int,Message8:int,Message:int,Param:int,ID:int");
ScriptRegistrant<JFW_Custom_Send_Custom> JFW_Custom_Send_Custom_Registrant("JFW_Custom_Send_Custom","RecieveMessage:int,RecieveCount:int,SendMessage:int,SendParam:int,SendID:int");
ScriptRegistrant<JFW_Custom_Multiple_Send_Custom> JFW_Custom_Multiple_Send_Custom_Registrant("JFW_Custom_Multiple_Send_Custom","RecieveMessage:int,RecieveCount:int,SendMessage:int,SendParam:int,SendID:int");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Custom> JFW_Create_Destroy_Object_On_Custom_Registrant("JFW_Create_Destroy_Object_On_Custom","Location:Vector3,Facing:float,Preset:string,CreateMessage:int,DestroyMessage:int");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Custom_Animate> JFW_Create_Destroy_Object_On_Custom_Animate_Registrant("JFW_Create_Destroy_Object_On_Custom_Animate","Location:Vector3,Facing:float,Preset:string,CreateMessage:int,DestroyMessage:int,Animation:string,Loop:int,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Custom_Animate_2> JFW_Create_Destroy_Object_On_Custom_Animate_2_Registrant("JFW_Create_Destroy_Object_On_Custom_Animate_2","Location:Vector3,Facing:float,Preset:string,CreateMessage:int,DestroyMessage:int,CreateAnimation:string,CreateLoop:int,CreateSubobject:string,CreateFirstFrame:float,CreateLastFrame:float,CreateBlended:int,DestroyAnimation:string,DestroySubobject:string,DestroyFirstFrame:float,DestroyLastFrame:float,DestroyBlended:int,Time:float,TimerNum:int");
ScriptRegistrant<JFW_Damaged_Send_Custom_Amount> JFW_Damaged_Send_Custom_Amount_Registrant("JFW_Damaged_Send_Custom_Amount","ID:int,Message1:int,Message2:int,Damage:float");
ScriptRegistrant<JFW_Invulnerable_On_Custom> JFW_Invulnerable_On_Custom_Registrant("JFW_Invulnerable_On_Custom","Message:int");
ScriptRegistrant<JFW_Invulnerable_On_Custom_2> JFW_Invulnerable_On_Custom_2_Registrant("JFW_Invulnerable_On_Custom_2","Message:int,InvulnerableArmour:string,NormalArmour:string");
ScriptRegistrant<JFW_Per_Preset_Visible_Person_In_Vechicle> JFW_Per_Preset_Visible_Person_In_Vechicle_Registrant("JFW_Per_Preset_Visible_Person_In_Vechicle","BoneName:string,Message:int");
ScriptRegistrant<JFW_Per_Preset_Visible_People_In_Vechicle> JFW_Per_Preset_Visible_People_In_Vechicle_Registrant("JFW_Per_Preset_Visible_People_In_Vechicle","BoneName1:string,BoneName2:string,Message1:int,Message2:int");
ScriptRegistrant<JFW_Visible_Person_Settings> JFW_Visible_Person_Settings_Registrant("JFW_Visible_Person_Settings","Message:int,ModelName:string,Animation:string,SubObject:string,FirstFrame:float,LastFrame:float,Blended:int");
ScriptRegistrant<JFW_Play_Animation_Destroy_Object> JFW_Play_Animation_Destroy_Object_Registrant("JFW_Play_Animation_Destroy_Object","Animation:string,Subobject:string,FirstFrame:float,LastFrame:float,Blended:int");
ScriptRegistrant<JFW_Custom_Send_Custom_Parameter> JFW_Custom_Send_Custom_Parameter_Registrant("JFW_Custom_Send_Custom_Parameter","ID:int,BaseMessage:int,Limit:int");
ScriptRegistrant<JFW_Create_Destroy_Object_On_Custom_Bone> JFW_Create_Destroy_Object_On_Custom_Bone_Registrant("JFW_Create_Destroy_Object_On_Custom_Bone","Location:Vector3,Facing:float,Preset:string,CreateMessage:int,DestroyMessage:int,BoneName:string");
